## DeepSeek-V3 高效训练关键技术分析


本文从模型架构、并行策略、通信优化和显存优化四个方面展开，深入分析了DeepSeek-V3高效训练的关键技术，探讨其如何以仅5%的算力实现对标GPT-4o的性能。

## 前言

今年春节 DeepSeek-V3&R1 对国内外 AI 圈产生了巨大的影响，其本质在于开拓了一条不同于 OpenAI 训练方法的道路，证明了通过模型架构和训练方法的极致优化，能够基于更少的算力资源训练出同等能力水平的大模型，这不仅让人们对 OpenAI 等厂商的**高** **算力投入产生质疑**，更通过将先进模型开源的策略对 OpenAI 等**闭源模型的商业模式形成了巨大冲击**。

本文试图探究 DeepSeek 为什么能够利用5%的算力训练出对标 GPT-4o 的先进模型，由于 DeepSeek-R1 源于 DeepSeek-V3 架构，且 DeepSeek-V3 论文中讲述了更多高效训练方法相关的内容，所以本文将以 DeepSeek-V3 为研究对象，分析其**在高效训练方面都采用了哪些关键技术**，未来再单独针对 DeepSeek-R1 进行分析总结。

![img](https://pic.yupi.icu/yuyi/1739511927574-2acfa88b-d104-4ccf-84df-fee2d5e43ba3.png)

## 一、模型架构

**1.1 高效的模型架构设计：多头潜在注意力 MLA 和 DeepSeekMoE 架构**

1. **多头潜在注意力 MLA**：MLA（Multi - head Latent Attention）架构与标准的MHA（Multi - head Attention）架构相比，核心是对注意力键和值进行低秩联合压缩，减少了推理时的 Key - Value（KV）缓存，减少了推理内存占用，提升了推理效率，该架构对训练过程无直接帮助，不是本文分析的重点。



2. **DeepSeekMoE 架构**：核心是采用了更细粒度的专家分配策略，每个MoE层有1个共享专家和256个路由专家（共有58个MoE层14906个专家），每个输入Token可以激活8个路由专家，**该架构可以有效利用计算资源，实现高效训练，其与标准MoE架构存在以下不同点：**



a)**专家构成**：标准MoE架构的类型和分工较为宽泛，一般不会特别强调共享专家的设置，各个专家相对独立的处理不同输入数据，在处理不同类型数据特征时，专家间一般缺少专门设计的协作和共享机制；而 DeepSeekMoE 架构中的共享专家可对不同输入数据中的共性特征进行处理，在不同类型的输入数据间实现共性特征的知识共享，**以便减少模型参数冗余**，而路由专家则负责处理具有特定模式或特征的数据，提高模型对不同数据的适应性和处理能力。



b)**专家分配**：标准MoE架构的专家分配策略相对比较粗放，门控网络根据输入数据进行专家选择时，对于一些复杂数据特征的区分不够精准，不能很好地将数据分配到最能处理该特征的专家；而 DeepSeekMoE 架构采用了**更细粒度的专家分配策略**，门控网络能够更精准地分析输入数据的特征，将其分配到最合适的专家，提升模型对于复杂数据的处理能力。

c)**专家激活**：标准MoE架构对于输入数据激活的专家数量没有固定标准，在某些情况下输入数据可能会激活过多非必要的专家，导致计算资源的浪费；而 DeepSeekMoE 架构明确了每个输入 Token 激活8个路由专家，在保证模型处理效果的同时，**避免了过度激活专家带来的计算资源浪费**，提高了计算效率、降低了计算成本；在具体实现方式上，共享专家会对每个输入 Token 进行处理，以便提取通用的基本特征，而路由专家会根据输入 Token 的特征而决定是否被激活参与计算。

![img](https://pic.yupi.icu/yuyi/1739511927657-4e2a84f6-32cb-4225-af5d-2cb9849f89c1.png)

**1.2 创新的负载均衡策略：无辅助损失负载均衡和序列级负载均衡**

#### 1. **基本概念**：
在MoE大模型训练过程中，输入数据会根据一定的路由规则分配到不同的专家模型进行处理，这个过程中可能会出现负载不均衡的情况，**即某些专家被频繁调用，而另一些专家则很少被使用**，这会导致训练效率和模型性能下降；

业界通常采用的负载均衡策略为引入专门的辅助损失函数来强制平衡专家之间的负载，例如通过惩罚专家之间的负载差异来促使模型均匀地使用各个专家，**额外引入的损失函数往往会导致模型复杂度增加、训练不稳定、发生与原本训练目标不一致等问题**；

除了上述基于单 Token 的负载不均问题外，一个输入序列中的 Token 在专家间的分配情况也容易出现负载不均，即同一序列中的多个 Token 可能会集中分配给某些专家。

#### 2. **优化方法**：
DeepSeek-V3 采用无辅助损失负载均衡技术，通过直接在路由机制中融入负载均衡逻辑，**避免了引入辅助损失函数**，实现了仅通过对路由决策动态调整就实现专家负载均衡的效果；同时训练过程**辅以序列级负载均衡策略**，确保了每个序列内的专家负载均衡。

a)**无辅助损失负载均衡**：DeepSeek-V3 为每个专家引入了一个可学习的偏置项，在训练过程中它会随着专家负载情况进行动态更新，当门控网络计算输入 Token 与各专家的匹配得分时，**该偏置项会动态调整每个专家的匹配得分**，基于得分和对各专家利用率的实时监测（例如在一定时间窗口内专家处理的 Token 数量、计算资源占用时长等），动态调整路由策略，将输入 Token 实时分配给负载较低的专家，这种方法不仅负载均衡效果好，而且避免了引入辅助损失函数带来的衍生问题。

b)**序列级负载均衡**：DeepSeek-V3 额外增加了一个序列级负载均衡损失函数，对序列中的每个 Token 进行精细化的分析和处理，**根据 Token 在序列中的位置、上下文信息等更合理地分配到各个专家**（而不是仅仅基于单个 Token 的特征进行独立分配），通过这种负载均衡方案，兼顾了 Token 之间的关联性和序列的整体结构。



**1.3 多令牌预测（MTP） 训练目标：提高训练效率和推理速度**

1. **基本概念**：MTP 的全称是 Multi - Token Prediction（多令牌预测），与之对应的是 DeepSeek-V3 发布之前业界普遍使用的单令牌预测（Single - Token Prediction，STP），STP 一次仅预测一个Token，而 MTP 可同时预测多个 Token，**这一方案在训练阶段可以提升数据训练效率，在推理阶段可以实现显著加速**。
2. **实现方案**：如 DeepSeek 论文中所展示的 MTP 架构所示，MTP 由一个主模型（Main Model）以及多个 MTP 模块（MTP Module 1、MTP Module 2 等）构成，**主模型负责基础的下一个 Token 预测任务，MTP 模块则用于预测多个未来 Token**，它们共同协作完成多Token 预测训练。

a)**输入 Token 与输出 Token**：如图左下方的t1、t2、t3、t4等，是模型的输入序列；如图上方的t2、t3、t4、t5是模型预测需要匹配的真实 Token 序列，不同部分对应不同的预测任务。

b)**主模型（Main Model）与 MTP 模块**：输入 Token 先经过嵌入层转换为向量表示，然后分别在 Main Model 和 MTP 内部进行计算，基于与目标 Token 计算得到的 Loss，指导模型更新训练参数。

c)**共享机制**：嵌入层（Embedding Layer）和输出头（Output Head）在主模型和 MTP 模块之间共享，**这种共享机制确保了模型在不同预测任务中的参数一致性，同时减少了参数数量，提高了训练效率。**

![img](https://pic.yupi.icu/yuyi/1739511927648-1e364721-a86e-4721-bf5f-cca03f0ba7d3.png)

3. **核心价值**：MTP 不仅在推理时能够显著加速生成速度（据称生成速度可提升 1.8 倍），对于高效训练同样很有价值。

a)**实现高效训练**：由于一次可预测多个 Token，在相同数据量的情况下，**相比 STP 架构，模型可以学习到更多的信息**，从而提升了数据的利用效率，使得训练更加高效。

b)**提升训练效果**：模型可以基于对多个 Token 的预测，更合理地调整自身参数，**学习到更丰富的语言模式和语义信息**，有助于模型在训练中更好地收敛，提升训练效果。

## 二、并行策略

**2.1 高效的并行策略设计：大量使用 EP、不再使用 TP**

1. **并行策略总结**：DeepSeek-V3 的训练由 HAI-LLM 框架（DeepSeek 自研训练框架）支持，采用了**16路流水线并行（PP），跨越8个节点的64路专家并行（EP），以及 ZeRO-1 数据并行（DP）**，实现了充分利用计算资源，提高训练效率，减少训练时间和成本。其中 PP 和 DP 将在本节后边两个要点进行分析，此处重点分析其为何没有使用 TP。
2. **使用 EP 而不是 TP**：在 DeepSeek-V3 训练中，优先使用 EP 而没有使用 TP 的原因核心有以下几个方面：

a)**模型结构适配性**：MoE 模型由多个专家网络和一个门控网络组成，**EP 正好与这种结构相匹配**，它可以将不同的专家分配到不同的计算单元上并行计算，让模型同时处理多个不同的任务或数据特征，**提高模型的处理能力和训练效率**；TP 通常用于处理大型张量的计算，不能很好地对应 MoE 模型的结构特点。

b)**通信成本考虑**：**在 EP 中不同专家之间的通信相对较少**，主要的通信开销在于门控网络与专家网络之间的信息交互，以及在进行模型参数更新等操作时的一些全局通信；TP 需要在多个设备之间频繁地进行张量的切分、合并等操作，通信量会随着模型规模和数据量的增加而显著增加，降低训练效率。

c)**计算资源利用率**：MoE 模型中的不同专家可能具有不同的计算复杂度和数据需求，**EP 可以根据各个专家的特点灵活地分配计算资源**，使不同性能的计算单元都能得到充分利用；TP 的资源分配方式相对单一，对于不同专家的多样性计算需求支持不佳。

**2.2 Dualpipe 流水线并行策略：双流并行计算优化与双向流水线调度优化**

1.**双流并行计算优化**：

**a)基本概念**：如 DeepSeek 在论文中所述，在训练过程中包含前向传递、反向传递两个阶段，具体包括**计算流和通信流**两个流。

1. 1. **前向传递**：通常按顺序执行 **ATTN（计算流）、DISPATCH（通信流）、MLP（计算流）、COMBINE（通信流）** 操作。

  - ATTN（计算流）：指注意力机制计算，使大模型能够捕捉文本等数据中的依赖关系，提升模型的性能和泛化能力。
  - DISPATCH（通信流）：指数据或任务在不同GPU节点之间的传递，提高整个训练系统的并行度和效率。
  - MLP（计算流）：即多层感知机计算，由输入层、输出层和一个或多个隐藏层构成，利用梯度下降法更新权重参数。
  - COMBINE（通信流）：指将不同GPU节点上将计算结果进行合并的通信操作。

ii. **反向传递**：需要执行 **COMBINE（通信流）、MLP_B（计算流）、MLP_W（计算流）、DISPATCH（通信流）、ATTN_B（计算流）、ATTN_W（计算流）** 操作:

  - COMBINE（通信流）：定义与前向传递相同，此处特指反向传递时的数据汇总，以便进行全局参数更新。
  - MLP_B（计算流）：此处的B指的是Bias，指的是反向传播中对于偏执项的计算，以便更新大模型的偏执参数。
  - MLP_W（计算流）：此处的W指的是Weight，指的是反向传播中对于权重参数的计算，用于更新权重参数。
  - DISPATCH（通信流）：在反向计算中，DISPATCH 的作用仍然是负责数据或任务的分发。
  - ATTN_B（计算流）：偏置项也会影响注意力权重的计算和最终的输出，通过计算调整注意力机制中的偏置参数。
  - ATTN_W（计算流）：计算损失函数对注意力权重的梯度，通过更新注意力权重捕捉数据中的依赖关系和重要信息。

![img](https://pic.yupi.icu/yuyi/1739511927683-afc5fe33-4e4a-4203-a0b1-a209ba05edd6.png)

**b)优化方法：** 此处的双流并行，指的是计算流和通信流，双流并行即在大模型训练的反向传递阶段，**将原本存在先后顺序的更新当前层权重（即MLP_B）和将梯度继续传递到前一层（即MLP_W）这两个操作，拆分成两个独立且并行的流**，同时通过细致的设计，让训练的 barrier 刚好停在两个流任务完成的时候，**而不需要通信流或者是计算流进行等待，提高计算效率**。

![img](https://pic.yupi.icu/yuyi/1739511927679-676fb960-da37-4560-ae80-7c8d9d9775bc.png)

2. **双向流水线调度优化** **：**

a)**基本概念**：PP并行方法中，**训练过程经常容易出现气泡（即GPU闲置）**，核心原因是在PP并行中不同的计算阶段可能具有不同的计算复杂度和执行时间，**导致计算快的阶段需要等待计算慢的阶段完成后才能继续进行下一轮计算**，同时不同阶段之间需要进行数据通信来传递中间结果，可能会受到网络带宽等影响导致数据传输延迟，如下图所示，其中有以下一些关键信息。

i.**颜色**：蓝色代表前向传播，绿色代表反向传播，**灰色代表空闲状态**（即气泡）。

ii.**数字**：表示不同的微批次（Micro - batch），图中不同GPU上的数字序列，反映了各个微批次在不同GPU上的计算顺序和时间分布。

![img](https://pic.yupi.icu/yuyi/1739511928276-250a49fd-0301-4af0-b433-47f0a634faad.png)

b)**优化方法：** 传统的单向流水线通常是按照固定顺序，从流水线起始端依次进行微批次（micro - batch）处理；而DeepSeek-V3在训练过程中**采用了双向流水线调度设计，即同时从两端进行微批次（micro - batch）处理**，减少流水线气泡，另外DeepSeek将每个 micro - batch 进一步划分为更小的块（chunk），**并对计算和通信进行精细调度，实现两者的高度重叠，提高 GPU 利用率**。

iii.**起始端**：在PP并行中，通常将设备编号较小的一端视为起始端，即图中的 Device 0。

iv.**末端**：设备编号较大的一端为末端，也就是图中的 Device 7，在双向流水线中，Device 7 等设备也会在合适的时机启动计算任务，且与起始端的计算任务相互配合，**并非只是被动等待起始端计算完成后才开始工作**。

![img](https://pic.yupi.icu/yuyi/1739511928296-2da235e7-5041-4cb2-a644-36cf771d675e.png)

**2.3 ZeRO-1(DP) 数据并行策略：降低内存占用，加速模型训练**

**1.基本概念：** ZeRO（Zero Redundancy Optimizer）即零冗余优化器，是由微软提出的一种旨在减少分布式训练中内存使用的技术框架；ZeRO-1(DP)结合了零冗余优化器的思想和数据并行策略。

**2.工作原理**：在传统的数据并行中，每个设备都保存完整的优化器状态（如梯度、参数等），这会导致内存冗余；而 ZeRO-1 会将优化器状态划分到不同的设备上，**每个设备只保存一部分优化器状态**，在反向传播计算完成后，各个设备会交换自己所负责的参数的梯度信息，然后根据这些梯度更新各自保存的部分优化器状态和模型参数；通过这种方式，**虽然每个设备只保存了部分信息，但最终所有设备上的模型参数会保持一致**。

**3.核心价值：**

a)**降低内存占用**：ZeRO-1(DP) 数据并行策略**显著降低了单个 GPU 的内存占用**，让模型能够在有限的显存中进行训练。

b)**加速模型训练**：首先由于内存占用降低，模型可以处理更大的批量数据，**提高了计算资源的利用率**，从而加快训练速度；另外ZeRO-1 通过在不同GPU之间共享一部分状态变量，**减少了 GPU 之间的通信开销**，进一步提升了整体训练效率。

## 三、通信优化

**3.1 Moe 路由的All2All优化设计：网络拓扑优化与资源分配优化**

#### **1.基本概念：** 
在MoE大模型训练中，需要将训练数据按照数据类型或特征分配给最合适的专家模型进行处理，**此时常用到两种数据路由方案**，一种是All to All通信方案，另一种是基于 Magetron 实现的All Reduce和Reduce Scatter通信方案，其优缺点大致如下：

a)**All to All通信**：在数据传输时，根据实际传输的数据量来开辟相应大小的显存空间；这种方案的**优势是显存开销小，劣势是由于是点对点通信、通信效率相对较低**。

b)**All Reduce和Reduce Scatter通信**：这种方案首先是将所有数据路由至每一张GPU，然后通过掩码筛选出每个专家模型真正需要的数据，再进行求和、求最大值等规约操作，并将数据重新合理分配至每一张GPU；这种方案的**优势是通信效率较高，劣势是显存开销比较大**。

1. **实现方案：** 在 DeepSeek-V3 的实际训练中，**选择了All to All的通信方案**，为了解决All to All在通信效率方面存在的劣势，**采用了众多通信优化手段**，比较核心的有以下几个方面。

a)**限制路由范围**：限制每个训练 token 最多只能被调度到 4 台GPU服务器，**减少跨节点间的 IB 流量**，规避了节点过多时训练 Token 随意路由导致的通信拥塞问题。

b)**网络拓扑优化**：DeepSeek-V3 的训练集群应该**采用了多轨组网方案**（其并未正式公布，从其他渠道了解信息猜测得到），确保服务器收发数据时，可以在不同节点的同号卡之间实现最少跳数的互联，所以在数据路由策略上，DeepSeek-V3 会通过IB网络将数据从源端服务器传输至目标服务器相同卡号的GPU上，然后基于 NVLink 转发至托管目标专家的特定GPU，实现高效机内和机间通信，最大化利用高速互联网络带宽。

c)**资源分配优化**：当期望训练流与通信流同时工作并达到重叠状态时（如二.2所述），就容易出现**GPU SM资源（SM即流多处理器，H800有132个SM）的争抢，DeepSeek-V3 通过使用定制化的 PTX（即网络上宣称绕过CUDA的语言）**，对GPU的132个SM进行了改造，专门划分出20个SM用于处理服务器间通信任务，并根据训练流和通信流的具体特点和需求，对指令执行进行优化，例如分配指令优先级、调整指令执行顺序等，减少 SM 资源分配和 L2 缓存抢占现象的发生。

d)**动态资源调整**：DeepSeek-V3 采用了自动调整的资源分配策略，**能够根据训练流和通信流在不同时刻的资源需求动态地分配 SM 和 L2 缓存资源**，系统能够通过为每个专家引入的偏置项，根据每个专家的历史利用率情况，动态地调整其接收新任务的概率，即无辅助损失负载均衡策略。

## 四、显存优化

**4.1 FP8 低精度训练：混合训练框架和精细量化策略**

1. **混合精度训练框架**：在 DeepSeek-V3 的训练中，对于占据大量计算量的 **GEMM（通用矩阵乘法）操作，采用 FP8 精度执行**，FP8 数据类型具有较低的内存占用和更快的计算速度，所以可以**显著提升计算效率、降低显存开销**；同时为了确保训练的稳定性，对于少数对精度要求比较高的关键操作，如嵌入模块（将输入 Token 转换为向量表示）、注意力操作等，**仍保持高精度（BF16/FP32）计算**。



2. **精细量化策略**：FP8 虽然在训练速度和显存占用方面优势明显，但是由于需要采取措施对训练数据、模型参数、中间激活值进行量化操作，**容易在训练过程中出现因量化误差导致的模型发散等问题**，影响训练稳定性和模型性能，DeepSeek-V3 在训练过程中采用了分块量化、块级量化、高精度累加**三种精细量化策略**解决这个问题。

a)**分块量化**：数据划分粒度相对较细，**将数据划分为多个小块**，然后对每个小块分别进行量化操作，这种方式能更精细地适应数据的局部特征，减少量化误差。

b)**块级量化**：数据划分粒度相对较粗，**对更大的块进行统一量化处理**，这种方式更关注数据的整体特征和分布情况，通过对较大块的数据采用相同的量化参数进行量化，可以简化量化计算过程，降低计算复杂度。

c)**高精度累加**：在一些关键计算步骤中，虽然中间计算过程使用了 FP8 精度以提高计算效率，**但在进行累加等操作时，会将 FP8 数据转换为更高精度的数据类型（BF16/FP32）进行累加**，然后再根据需要转换回 FP8 精度进行后续计算，这种机制可以有效控制量化误差的积累。

![img](https://pic.yupi.icu/yuyi/1739511928288-566f276e-7343-4210-96bd-cd40571b97ec.png)



**4.2 选择重计算：间隔重计算和选择性重计算优化**

1. **基本概念：** 在训练过程中，需要占用大量的显存来存储模型参数、中间结果等数据，当模型参数规模较大或者训练数据量较多时，可能会出现显存不够用的情况；所以业界会采用重计算优化方法，**即在前向传播时不保存上述的中间结果数据，而是在反向传播需要的时候重新计算它们**，大大减少中间结果所占用的显存空间。
2. **实现方案：** 比较粗暴的实现方案是完全重计算，这种方案因为计算量较大，会大幅增加训练全过程时间，所以业界一直在探索更为高效的选择重计算方案，DeepSeek-V3 在训练过程中主要应用了**间隔重计算和选择性重计算**两种优化手段。

a)**间隔重计算**：即“**隔一层重计算一次**” ，在反向传播中对一半层的输入输出进行重计算，另一半层按照传统方式保存中间结果数据。

b)**选择性重计算**：大模型每一层的计算，通常由**类似 RMSkernel 的计算强度较弱的部分**（包含平方、求和、开方等计算操作，用于稳定训练过程、加速模型收敛）和**计算强度较强的 GEMM 矩阵乘法部分组成**，他们虽然都会产生中间结果，但是计算成本差异较大；通常 RMSkernel 的计算时间占比小、但**单位计算的显存占用大**，而GEMM的计算时间占比大、但**单位计算的显存占用小**；所以选择性重计算方法**重点是针对 RMSkernel 相关的部分算子进行重计算，获得最大的性价比。**

**4.3 EMA显存优化：异步处理与显存卸载优化**

1. **基本概念：** EMA是指数移动平均（Exponential Moving Average），它对于模型训练过程中每一步更新得到的参数，计算指数加权平均值，得到一组新的参数，用于监测训练方向，**避免噪声对于模型参数更新的影响，以得到更加稳定、泛化能力更强的参数**；由于EMA需要额外维护一组参数，所以会占用一定的显存空间。

2.**实现方案**：DeepSeek-V3 在训练过程中采用了异步处理和显存卸载方法，优化了EMA的显存占用。

a)**异步处理**：由于EMA的计算过程并不需要训练过程中实时产生的数据，所以可以独立于前向传播和反向传播而开展，DeepSeek采用异步处理方式，**让EMA计算过程与训练过程并行开展。**

b)**显存卸载**：基于上述异步处理的基础，**可以将EMA计算从GPU显存卸载至CPU**，即在每一轮训练结束后，将模型参数传递给CPU，在 CPU 上计算 EMA 参数，然后将更新后的 EMA 参数存储在 CPU 内存中，减少GPU的显存占用。

**4.4 头尾参数共享：embedding 层和 lm_head 层共享参数的优化策略**

**1.基本概念：** embedding层位于模型首端，核心作用是把离散的 Token 转换为连续的向量表示，实现这一转换依靠的是一个可学习的权重矩阵，其大小为 vocab_size * hidden_size（词表大小 * 每个 Token 对应的嵌入向量的维度）；lm_head 层位于模型的末端，将模型输出的嵌入向量重新映射回 Token 的概率分布，以便计算损失函数，其实现方式同样是依赖一个大小为 vocab_size * hidden_size 的权重矩阵。

**2.实现方案：**头尾参数共享，指的是**让 embedding 层和 lm_head 层使用同一个权重矩阵**，这种优化方案由于减少了参数存储量，与之相关的梯度、优化器状态和参数备份等占用的显存也会相应减少，**且共用的权重矩阵有助于模型学习到更稳定和通用的 Token 表示**，从而提高模型的性能和泛化能力。

## 总结

通过上述对 DeepSeek-V3 高效训练关键技术的分析，我们能够看出，DeepSeek-V3 之所以能够利用5%的算力训练出对标 GPT-4o 的先进模型，与其创新性的模型架构设计、高效的并行策略选择以及对集群通信和显存的极致优化密不可分，**高效训练方法的表象是需要更少规模的算力**，**但其本质是对算法创新和极致集群性能的更高要求**，所以 DeepSeek-V3 的先进经验对于 AI Infra 绝不是利空，反而随着精细化的高效训练方法被业界普遍采用，**基于先进芯片选型、先进架构搭建的 AI Infra 的重要性会越发凸显**，持续学习。



> 来源：https://news.qq.com/rain/a/20250211A01HDY00?utm_source=chatgpt.com